
clear all;
%Set input file here.
filename = 'RF_Data_Experiment.txt'; %'RfData_May2_2016_depth2.5cm.txt';
Rf_exp = (importdata(filename))';

%Set the rebeamformer parameters here (for scaling image).
soundSpeed = 1480; %speed of sound of ultrasound
no_ele = 128; %total number of elements
channelSpacing = 60/128;%distance between element to element
fs = 40e6;%20.70e6; %sample frequency
%sampleSpacing = (1/fs)*soundSpeed*1e3; %sample number vs mm
sample = size(Rf_exp,1);
times = 1;

%Execute c++ rebeamforming algorithm.
input = ['RebeamformerTest.exe ',filename];
system(input);
bfdata = (importdata('PA_Outputdata.txt'))';

%% Display Beamformed Image
%imagesc(db(abs(hilbert(Rf512))));
figure();

%imagesc(db(bfdata));
%colormap('jet');

Bpost_DAQ = abs(hilbert(bfdata));%hilbert(bfdata));
Bpost_DAQ = Bpost_DAQ/max(max(Bpost_DAQ));
st = 100;
y = ([st sample-100]/(fs))*soundSpeed*1000;
x = [1 no_ele*times] * (channelSpacing);
%imagesc(db(Bpost_DAQ))
imagesc(x,y,(Bpost_DAQ(st:sample-100,:)))%,[-20 0]);
axis image;
%axis equal;

colormap('gray');
title('Rebeamformed Pseudo-PA Signal');
xlabel('Lateral Distance (mm)');
ylabel('Depth (mm)');



%% Display Original Image

figure();
imagesc(x,y,abs(hilbert(Rf_exp(st:sample-100,:))));
%imagesc(db(Rf_exp));
colormap('gray');
%title('US Beamformed RF Data');
axis image;
title('Prebeamformed Pseudo-PA Signal');
xlabel('Lateral Distance (mm)');
ylabel('Depth (mm)');

%plot(1:1:size(Rf_exp,1),Rf_exp(:,2))
%title('RF Element Data');
%xlabel('Sampling Depth');
%ylabel('RF Amplitude');